### **实验名称**

MongoDB 数据库的文档基本操作 - 查询

### **实验目的**

1. 掌握 MongoDB 查询；
2. 掌握常用函数，如聚合，分组等。

### **实验背景**

MongoDB 是由 C++ 语言编写的非关系型数据库，是一个基于分布式文件存储的开源数据库系统，其内容存储形式类似 JSON 对象，它的字段值可以包含其他文档、数组及文档数组，非常灵活。

MongoDB 是一个介于关系数据库和非关系数据库之间的产品，是非关系数据库当中功能最丰富，最像关系数据库的。

### **实验原理**

1. 使用 findOne() 方法和 find() 方法进行文档基本查询

   语法格式如下：

   ```js
   db.collection.findOne(query) // 查询单条文档
   db.collection.find(query) // 查询多条文档
   ```

   参数说明：

   query ：可选，使用查询操作符指定查询条件。

   projection ：可选，使用投影操作符指定返回的键。查询时返回文档中所有键值， 只需省略该参数即可（默认省略）。

2. 文档查询条件的使用

   ![03-2.5-1-文档查询条件.png](./pic/03-2.5-1-文档查询条件.png)

3. 特定类型查询

   针对特定类型的文档进行查询，如查询键为 NULL 的空文档

4. 聚合查询

   MongoDB 中聚合（aggregate）主要用于处理数据（诸如统计平均值、求和等），并返回计算后的数据结果。db.collection.aggregate() 是基于数据处理的聚合管道，每个文档通过一个由多个阶段（stage）组成的管道，可以对每个阶段的管道进行分组、过滤等功能，然后经过一系列的处理，输出相应的结果。

   ![03-2.5-2-聚合查询.png](./pic/03-2.5-2-聚合查询.png)

### **实验环境**

OS：Ubuntu18.04

MongoDB：6.0.8

### **建议课时**

1课时

### **实验步骤**

一、MongoDB 查询

1. 启动 mongo shell

   （1）在指定目录下创建 mongodb 文件夹、其子文件夹 data、log 以及文件 mongodb.log

      ```sh
   cd /home/ubuntu
   mkdir -p mongodb/data
   mkdir -p mongodb/log
   touch mongodb/log/mongodb.log
      ```

   （2）先执行 mongod 命令以启动 mongod 服务

   ```sh
   mongod --dbpath /home/ubuntu/mongodb/data --logpath /home/ubuntu/mongodb/log/mongodb.log --logappend --fork
   ```

   （3）进入 mongo shell

   ```sh
   mongosh
   ```

   ![03-2.5-3-启动mongosh.png](./pic/03-2.5-3-启动mongosh.png)

2. 使用 test 数据库，并新建 items 集合，保存订单相关信息

   ```js
   use test
   db.createCollection("items")
   ```

   ![03-2.5-4-创建集合.png](./pic/03-2.5-4-创建集合.png)

3. 批量插入文档数据

   每个文档对应订单中某个商品相关信息，包括：

   pnumber：商品编号

   quantity：商品数量

   price：商品单价

   插入如下商品信息：

   ```js
   db.items.insertMany([
     { quantity: 2, price: 5.0, pnumber: 'p003' },
     { quantity: 2, price: 8.0, pnumber: 'p002' },
     { quantity: 1, price: 4.0, pnumber: 'p002' },
     { quantity: 2, price: 4.0, pnumber: 'p001' },
     { quantity: 4, price: 10.0, pnumber: 'p003' },
     { quantity: 10, price: 20.0, pnumber: 'p001' },
     { quantity: 10, price: 20.0, pnumber: 'p003' },
     { quantity: 5, price: 10.0, pnumber: 'p002' },
   ])
   ```

   ![03-2.5-5-批量插入.png](./pic/03-2.5-5-批量插入.png)

4. 查询插入结果

   使用 find({}) 方法显示所有文档

   ![03-2.5-6-查询所有文档-1.png](./pic/03-2.5-6-查询所有文档-1.png)

   ![03-2.5-6-查询所有文档-2.png](./pic/03-2.5-6-查询所有文档-2.png)

5. 统计 items 共有多少个文档数据

   ```js
   db.items.countDocuments()
   ```

   ![03-2.5-7-countDocuments.png](./pic/03-2.5-7-countDocuments.png)

6. 查询价格大于5的商品数据

   大于使用 gt 操作符，另外操作符前面要带上 $ 符号

   ```js
   db.items.find({ price: { $gt: 5 } })
   ```

   ![03-2.5-8-大于5-1.png](./pic/03-2.5-8-大于5-1.png)

   ![03-2.5-8-大于5-2.png](./pic/03-2.5-8-大于5-2.png)

7. 多条件查询

   例：查询数量 quantity 为10**且**价格 price 大于等于5的商品数据

   ```js
   db.items.find({ quantity: 10, price: { $gte: 5 } })
   ```

   ![03-2.5-9-多条件查询.png](./pic/03-2.5-9-多条件查询.png)

8. 使用 or 来进行条件查询

   （1）语法格式如下：

   ```js
   db.col.find({ $or: [{ key1: value1 }, { key2: value2 }] })
   ```

   （2）示例：查询数量 quantity为10**或**价格 price 大于等于5的商品数据

   ```js
   db.items.find({ $or: [{ quantity: 10 }, { price: { $gte: 5 } }] })
   ```

   ![03-2.5-10-or-1.png](./pic/03-2.5-10-or-1.png)

   ![03-2.5-10-or-2.png](./pic/03-2.5-10-or-2.png)

9. AND 和 OR 联合使用

   示例：查询编号 pnumber为 “p003” 且数量 quantity 为10或价格大于等于5的商品数据

   ```js
   db.items.find({ pnumber: 'p003', $or: [{ quantity: 10 }, { price: { $gte: 5 } }] })
   ```

   ![03-2.5-11-and&or.png](./pic/03-2.5-11-and&or.png)

10. 使用聚合 aggregate

    （1）示例：统计订单中所有商品的数量，即统计数量 quantity 的总和

    ```js
    db.items.aggregate([{ $group: { _id: null, total: { $sum: '$quantity' } } }])
    ```

    ![03-2.5-12-统计.png](./pic/03-2.5-12-统计.png)

    （2）示例：通过产品类型来进行分组，然后再统计卖出的数量

    ```js
    db.items.aggregate([{ $group: { _id: '$pnumber', total: { $sum: '$quantity' } } }])
    ```

    ![03-2.5-13-产品分组.png](./pic/03-2.5-13-产品分组.png)

    （3）示例：通过相同的产品类型来进行分组，然后查询相同产品类型卖出最多的订单详情

    ```js
    db.items.aggregate([{ $group: { _id: '$pnumber', max: { $max: '$quantity' } } }])
    ```

    ![03-2.5-14-产品max.png](./pic/03-2.5-14-产品max.png)

    （4）示例：通过相同的产品类型来进行分组，然后查询每个订单详情相同产品类型卖出的平均价格

    ```js
    db.items.aggregate([{ $group: { _id: '$pnumber', price: { $avg: '$price' } } }])
    ```

    ![03-2.5-15-avg.png](./pic/03-2.5-15-avg.png)

11. 管道的使用

    示例：通过相同的产品类型来进行分组，统计各个产品数量，然后获取最大的数量。

    ```js
    db.items.aggregate([{ $group: { _id: '$pnumber', total: { $sum: '$quantity' } } }, { $group: { _id: null, max: { $max: '$total' } } }])
    ```

    ![03-2.5-16-管道.png](./pic/03-2.5-16-管道.png)

### **实验总结**

该实验的主要内容是 MongoDB 的查询方法的使用。通过实操能够掌握文档查询条件的使用。countDocuments() 统计查询，以及多条件查询等；聚合查询：MongoDB 中聚合（aggregate）主要用于处理数据（诸如统计平均值，求和等），并返回计算后的数据结果以及分组函数 group 函数等的使用。